% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateClonality.R
\name{plotClonality}
\alias{plotClonality}
\title{Plotting assigned clonality status for every SNV by chromosome}
\usage{
plotClonality(
  snvClonality = snvClonality,
  nbObj = NULL,
  sig.assign = FALSE,
  output.file = NULL,
  ...
)
}
\arguments{
\item{snvClonality}{output generated from \code{\link{estimateClonality}}.}

\item{nbObj}{output generated from \code{\link{nbImport}}.}

\item{sig.assign}{Logical. If TRUE, clonality status distribution will be
plotted for each SBS signature.}

\item{output.file}{optional, will save the mutational signatures stratified
by Clonality.}

\item{...}{further arguments and parameters passed to other LACHESIS
functions.}
}
\value{
graphs with clonality status of SNVs per chromosome and if specified,
stratified by signature
}
\description{
Visualizes results from  \code{\link{estimateClonality}}.
}
\examples{
# Example using variants associated with specific SBS mutational signatures
# from vcf file
snvs <- system.file("extdata", "NBE15",
    "snvs_NBE15_somatic_snvs_conf_8_to_10.vcf",
    package = "LACHESIS"
)
s_data <- readVCF(vcf = snvs, vcf.source = "dkfz")
aceseq_cn <- system.file("extdata", "NBE15",
    "NBE15_comb_pro_extra2.51_1.txt",
    package = "LACHESIS"
)
c_data <- readCNV(aceseq_cn)
sig.filepath <- system.file("extdata",
    "NBE15_Decomposed_MutationType_Probabilities.txt",
    package = "LACHESIS"
)
nb <- nbImport(
    cnv = c_data, snv = s_data, purity = 1, ploidy = 2.51,
    sig.assign = TRUE, ID = "NBE15", sig.file = sig.filepath
)
cl_muts <- clonalMutationCounter(nb)
norm_muts <- normalizeCounts(cl_muts)
mrca <- MRCA(norm_muts)
snvClonality <- estimateClonality(
    nbObj = nb, mrcaObj = mrca,
    ID = "NBE15", purity = 1
)
plotClonality(snvClonality, nbObj = nb, sig.assign = TRUE)

}
