% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13.search_distalCPs.R
\name{search_distalCPs}
\alias{search_distalCPs}
\title{search distal CP sites}
\usage{
search_distalCPs(
  chr.cov.merge,
  conn_next_utr3,
  curr_UTR,
  window_size,
  depth.weight,
  long_coverage_threshold,
  background,
  z2s
)
}
\arguments{
\item{chr.cov.merge}{merged coverage data for a given chromosome}

\item{conn_next_utr3}{A logical(1) vector, indicating whether joint to next
3UTR or not (used by \code{\link[=remove_convergentUTR3s]{remove_convergentUTR3s()}})}

\item{curr_UTR}{GRanges of 3' UTR for a given chromosome}

\item{window_size}{An integer(1) vector, the window size for novel distal or
proximal CP site searching. default: 100.}

\item{depth.weight}{A named vector. One element of an output of
\code{\link[=setup_CPsSearch]{setup_CPsSearch()}} for coverage depth weight, which is the output of
\code{\link[=get_depthWeight]{get_depthWeight()}}}

\item{long_coverage_threshold}{An integer(1) vector, specifying the cutoff
threshold of coverage for the terminal of long form 3' UTRs. If the coverage
of first 100 nucleotides is lower than coverage_threshold, that transcript
will be not considered for further analysis. Default, 2.}

\item{background}{A character(1) vector, the range for calculating cutoff
threshold of local background. It can be "same_as_long_coverage_threshold",
"1K", "5K","10K", or "50K".}

\item{z2s}{one element of an output of \code{\link[=setup_CPsSearch]{setup_CPsSearch()}} for Z-score cutoff
values, which is the output of \code{\link[=get_zScoreCutoff]{get_zScoreCutoff()}}}
}
\value{
a list
#' \itemize{\item dCPs, a data frame converted from GRanges
\item chr.cov.merge, depth-normalized sample/condition specific
coverage
\item next.exon.gap, all-in-one collapsed, refined next.exon.gap
coverage
\item annotated.utr3,all-in-one collapsed coverage for annotated
proximal UTRs
}
}
\description{
search distal CP sites
}
\seealso{
\code{\link[=get_PAscore2]{get_PAscore2()}}
}
\author{
Jianhong Ou
}
\keyword{internal}
