% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantifyExpressionsFromBAMs.R
\name{quantifyExpressionsFromBAMs}
\alias{quantifyExpressionsFromBAMs}
\title{Evaluate introns and exons expressions from BAM or SAM files}
\usage{
quantifyExpressionsFromBAMs(
  txdb,
  BAMfiles,
  experimentalDesign,
  by = c("gene", "tx"),
  countMultiMappingReads = FALSE,
  allowMultiOverlap = FALSE,
  prioritizeExons = TRUE,
  libsize = c("assigned", "all"),
  strandSpecific = 0,
  isPairedEnd = FALSE,
  DESeq2 = TRUE,
  varSamplingCondition = NULL,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{txdb}{A TranscriptDB object}

\item{BAMfiles}{A vector of paths}

\item{experimentalDesign}{A numerical which reports the desing of the experiment in terms of time points and replicates.
Time points must be ordered according to the sequence of files submitted for the analysis, these labels characterize
different files as replicates of a given condition.}

\item{by}{A character, either "gene" or "tx", indicating if expressions and counts should be summarized at the levels of 
genes or transcripts. "gene" by default.
In case "tx" is selected, we suggest to set argument "allowMultiOverlap" to TRUE, otherwise the reads mapping to overlapping
transcripts of the same gene will remain unassigned.}

\item{countMultiMappingReads}{A logical, if multimapping reads should be counted, FALSE by default. Multimap reads are 
identified using the tag "NH" in the bam/sam file.}

\item{allowMultiOverlap}{A logical, indicating if a read is allowed to be assigned to more than one feature, FALSE by default}

\item{prioritizeExons}{A logical, indicating whether reads assigned to exon shold not be accounted for intron counts.
If set to FALSE, reads with shared overlap between an exon and the following intron will be assigned also to introns. This could improve
intronic quantification in experimental settings (including polyA library preparation) or compact genomes were intronic reads are 
sampled at a very low rate compared to exonic reads. By default, TRUE.}

\item{libsize}{A character, either "assigned" or "all", indicating whether the libsize for expression normalization should include all 
mapped reads or only the reads assigned to any of the features. By default, "assigned" is selected.}

\item{strandSpecific}{Numeric, 0 if no strand-specific read counting should be performed, 1 stranded, 2 reversely-stranded. 0 by default}

\item{isPairedEnd}{A logical, if paired-end reads are used, FALSE by default}

\item{DESeq2}{A logical, if TRUE exons and introns variances are evaluated through the package DESeq2, if FALSE through plgem}

\item{varSamplingCondition}{A character reporting which experimental condition should be used to sample the variance if DESeq2 = FALSE.}

\item{BPPARAM}{Parallelization parameters for bplapply. By default SerialParam()
By default, the first element of "experimentalDesign" with replicates.}
}
\value{
A list containing expressions and associated variances for exons and introns.
}
\description{
Given a TranscriptDb object and a list of BAM or SAM files 
"quantifyExpressionsFormBAMs" evaluates exons and introns expressions
and the associated variances per each gene.
}
\examples{
if( Sys.info()["sysname"] != "Windows" ) {
  require(TxDb.Mmusculus.UCSC.mm9.knownGene)
  txdb<-TxDb.Mmusculus.UCSC.mm9.knownGene
  expDes<-c(0,0,1,1)
  
  paths_total<-system.file('extdata/', c('bamRep1.bam'
                                        ,'bamRep2.bam'
                                        ,'bamRep3.bam'
                                        ,'bamRep4.bam')
                          ,package='INSPEcT')
 
  matExp<-quantifyExpressionsFromBAMs(txdb=txdb
                                     ,BAMfiles=paths_total
                                     ,experimentalDesign=expDes)
}
}
