% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{RunUMAP}
\alias{RunUMAP}
\alias{RunUMAP.SingleCellExperiment}
\alias{RunUMAP,SingleCellExperiment-method}
\title{Uniform Manifold Approximation and Projection (UMAP)}
\usage{
RunUMAP.SingleCellExperiment(object)

\S4method{RunUMAP}{SingleCellExperiment}(object)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}
}
\value{
object of \code{SingleCellExperiment} class
}
\description{
Run nonlinear dimensionality reduction using UMAP with
the PCA-transformed consensus matrix as input.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- RunUMAP(sce)

}
\keyword{Approximation}
\keyword{Manifold}
\keyword{Projection}
\keyword{UMAP}
\keyword{Uniform}
\keyword{and}
