% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{PrepareILoReg}
\alias{PrepareILoReg}
\alias{PrepareILoReg.SingleCellExperiment}
\alias{PrepareILoReg,SingleCellExperiment-method}
\title{Prepare \code{SingleCellExperiment} object for \code{ILoReg} analysis}
\usage{
PrepareILoReg.SingleCellExperiment(object)

\S4method{PrepareILoReg}{SingleCellExperiment}(object)
}
\arguments{
\item{object}{an object of \code{SingleCellExperiment} class}
}
\value{
an object of \code{SingleCellExperiment} class
}
\description{
This function prepares the \code{SingleCellExperiment} object for
\code{ILoReg} analysis. The only required input is an object of class
\code{SingleCellExperiment} with at least data in the \code{logcounts} slot.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)

}
\keyword{clean}
\keyword{data}
\keyword{iloreg}
\keyword{normalized}
\keyword{prepare}
