% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{ClusteringScatterPlot}
\alias{ClusteringScatterPlot}
\alias{ClusteringScatterPlot.SingleCellExperiment}
\alias{ClusteringScatterPlot,SingleCellExperiment-method}
\title{Visualize the clustering over nonliner dimensionality reduction}
\usage{
ClusteringScatterPlot.SingleCellExperiment(
  object,
  clustering.type,
  return.plot,
  dim.reduction.type,
  point.size,
  title,
  show.legend
)

\S4method{ClusteringScatterPlot}{SingleCellExperiment}(
  object,
  clustering.type = "manual",
  return.plot = FALSE,
  dim.reduction.type = "",
  point.size = 0.7,
  title = "",
  show.legend = TRUE
)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{clustering.type}{"manual" or "optimal". "manual" refers to the
clustering formed using the "SelectKClusters" function and "optimal" to
the clustering formed using the "CalcSilhInfo" function.
Default is "manual".}

\item{return.plot}{a logical denoting whether to return the ggplot2 object.
Default is \code{FALSE}.}

\item{dim.reduction.type}{"tsne" or "umap". Default is "tsne".}

\item{point.size}{point size. Default is Default is \code{0.7}.}

\item{title}{text to write above the plot}

\item{show.legend}{whether to show the legend on the right side of the plot.
Default is \code{TRUE}.}
}
\value{
ggplot2 object if return.plot=TRUE
}
\description{
ClusteringScatterPlot function enables visualizing the clustering over
nonliner dimensionality reduction (t-SNE or UMAP).
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- HierarchicalClustering(sce)
sce <- SelectKClusters(sce,K=5)
sce <- RunTSNE(sce)
ClusteringScatterPlot(sce,"manual",dim.reduction.type="tsne")
sce <- RunUMAP(sce)
ClusteringScatterPlot(sce,"manual",dim.reduction.type="umap")

}
\keyword{clustering}
\keyword{dimensionality}
\keyword{nonlinear}
\keyword{plot}
\keyword{reduction}
\keyword{scatter}
