% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getData.R
\name{getData}
\alias{getData}
\title{Get data from HoloFood database}
\usage{
getData(
  type = NULL,
  accession.type = NULL,
  accession = NULL,
  flatten = FALSE,
  ...
)
}
\arguments{
\item{type}{\code{NULL} or \code{character scalar} specifying the type of
data to query. Must be one of the following options:
\code{"analysis-summaries"}, \code{"animals"}, \code{"genome-catalogues"},
\code{"samples"}, \code{"sample_metadata_markers"} or
\code{"viral-catalogues"}. When genome or viral catalogues is fetched by
their accession ID, the type can also be \code{"genomes"} or
\code{"fragments"}. (Default: \code{NULL})}

\item{accession.type}{\code{NULL} or \code{character scalar} specifying the
type of accession IDs. Must be one of the following options:
\code{"animals"}, \code{"genome-catalogues"}, \code{"samples"} or
\code{"viral-catalogues"}. (Default: \code{NULL})}

\item{accession}{\code{NULL} or \code{character vector} specifying the
accession IDs of type \code{accession.type}. (Default: \code{NULL})}

\item{flatten}{\code{Logical scalar} specifying whether to flatten the
resulting \code{data.frame}. This means that columns with multiple values
are separated to multiple columns. (Default: \code{FALSE})}

\item{...}{optional arguments:
\itemize{

  \item \strong{max.hits} \code{NULL} or \code{integer scalar} specifying the
  maximum number of results to fetch. When NULL, all results are fetched.
  (Default: \code{NULL})
  
  \item \strong{use.cache} \code{Logical scalar} specifying whether to
  use cache (Default: \code{FALSE})
  
  \item \strong{cache.dir} \code{Character scalar} specifying cache
  directory. (Default: \code{tempdir()})
  
  \item \strong{clear.cache} \code{Logical scalar} specifying whether to
  remove and clear cache (Default: \code{FALSE})
  
}}
}
\value{
\code{list} or \code{data.frame}
}
\description{
Get data from HoloFood database
}
\details{
With \code{getData}, you can fetch data from the database. Compared to
\code{getResult}, this function is more flexible since it can fetch any kind
of data from the database. However, this function returns the data
without further wrangling as \code{list} or \code{data.frame} which are not
optimized format for fetching data on samples.

Search results can be filtered; for example, animals can be filtered based on
available samples. See [Api browser](https://www.holofooddata.org/api/docs)
for information on filters. You can find help on customizing queries from
[here](https://emg-docs.readthedocs.io/en/latest/api.html#customising-queries).
}
\examples{

# Find genome catalogues
catalogues <- getData(type = "genome-catalogues")
head(catalogues)

# Find genomes based on certain genome catalogue iD
res <- getData(
    type = "genomes", accession.type = "genome-catalogues",
    accession = catalogues[1, "id"], max.hits = 100)
# See the data.
head(res)
# It includes for instance summary of the CAZy
# (Carbohydrate-Active enZymes) annotations as a counts per category
cazy <- res[ , grepl("annotations.cazy", colnames(res)), drop = FALSE]
head(cazy)
# Moreover, it includes a sample list. This sample list represents a 
# collection of samples where the MAG was identified. Thr data has also the
# completeness of MAG in a sample.
head(res[ c("metadata.Sample_accession", "metadata.Completeness")])

}
\seealso{
\code{\link[HoloFoodR:getResult]{getResult}}
}
