% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{QtlThreshold}
\alias{QtlThreshold}
\title{Find threshold for outliers based on quantiles.}
\usage{
QtlThreshold(x = NULL, prctThr = 5, tails = "both")
}
\arguments{
\item{x}{\if{html}{\out{<numeric>}}: Numeric vector.}

\item{prctThr}{\if{html}{\out{<numeric>}}: Percentage (0-100) threshold.
(Default 5)}

\item{tails}{\if{html}{\out{<character>}}: Bounds to return, "lower", "upper"
or "both". (Default "both")}
}
\value{
Numerical vector of thresholds values for outliers triming.
}
\description{
Find threshold for outliers triming based on quantiles.
}
\details{
QtlThreshold
}
\examples{
set.seed(1111)
x <- 0:100
x <- sort(x)
x
QtlThreshold(x, prctThr = 5, tails = "lower")
QtlThreshold(x, prctThr = 5, tails = "both")
QtlThreshold(x, prctThr = 5, tails = "upper")
}
\keyword{internal}
