% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilda_test.R
\name{hildaTest}
\alias{hildaTest}
\title{Apply HiLDA to statistically testing the global difference in burdens of
mutation signatures between two groups}
\usage{
hildaTest(
  inputG,
  numSig,
  refGroup,
  useInits = NULL,
  sigOrder = NULL,
  nIter = 2000,
  nBurnin = 0,
  pM1 = 0.5,
  localTest = TRUE,
  ...
)
}
\arguments{
\item{inputG}{a MutationFeatureData S4 class output by the pmsignature.}

\item{numSig}{an integer number of the number of mutational signatures.}

\item{refGroup}{the indice indicating the samples in the reference group.}

\item{useInits}{a EstimatedParameters S4 class output by the pmsignature
(default: NULL)}

\item{sigOrder}{the order of the mutational signatures.}

\item{nIter}{number of total iterations per chain (default: 2000).}

\item{nBurnin}{length of burn (default: 0).}

\item{pM1}{the probability of sampling the null (default: 0.5)}

\item{localTest}{a logical value (default: TRUE)}

\item{...}{Other arguments passed on to methods.}
}
\value{
the output jags file
}
\description{
Apply HiLDA to statistically testing the global difference in burdens of
mutation signatures between two groups
}
\examples{

load(system.file("extdata/sample.rdata", package="HiLDA"))

## with initial values
hildaLocal <- hildaTest(inputG=G, numSig=3, refGroup=1:4, nIter=1000,
localTest=TRUE)
hildaGlobal <- hildaTest(inputG=G, numSig=3, refGroup=1:4, nIter=1000,
localTest=FALSE)

}
