% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_file.R
\name{hildaReadMPFile}
\alias{hildaReadMPFile}
\title{Read the raw mutation data of Mutation Position Format.}
\usage{
hildaReadMPFile(
  infile,
  numBases = 3,
  trDir = FALSE,
  bs_genome = NULL,
  txdb_transcript = NULL
)
}
\arguments{
\item{infile}{the path for the input file for the mutation data of Mutation
Position Format.}

\item{numBases}{the number of upstream and downstream flanking bases
(including the mutated base) to take into account.}

\item{trDir}{the index representing whether transcription direction is
considered or not.
The gene annotation information is given by UCSC knownGene
(TxDb.Hsapiens.UCSC.hg19.knownGene object) When trDir is TRUE, the mutations
located in intergenic region are excluded from the analysis.}

\item{bs_genome}{this argument specifies the reference genome (e.g., B
Sgenome.Mmusculus.UCSC.mm10 can be used for the mouse genome).
See https://bioconductor.org/packages/release/bioc/html/BSgenome.html for the
available genome list}

\item{txdb_transcript}{this argument specified the transcript database
(e.g., TxDb.Mmusculus.UCSC.mm10.knownGene can be used for the mouse genome).
See https://bioconductor.org/packages/release/bioc/html/AnnotationDbi.html
for details.}
}
\value{
The output is an instance of MutationFeatureData S4 class (which
stores summarized information on mutation data). This will be typically used
as the initial values for the global test and the local test.
}
\description{
The mutation position format is tab-delimited text file, where
the 1st-5th columns shows sample names, chromosome names,
coordinates, reference bases (A, C, G, or T) and
the alternate bases (A, C, G, or T), respectively. An example is as follows;

---

sample1 chr1 100 A C

sample1 chr1 200 A T

sample1 chr2 100 G T

sample2 chr1 300 T C

sample3 chr3 400 T C

---

Also, this function usually can accept compressed files (e.g., by gzip, bzip2
and so on) when using recent version of R.
}
\examples{
inputFile <- system.file("extdata/esophageal.mp.txt.gz", package="HiLDA")
G <- hildaReadMPFile(inputFile, numBases=5, trDir=TRUE)


}
