% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_transformations.R
\name{full2sparse}
\alias{full2sparse}
\title{Transfrom a full Hi-C contact matrix to a sparse upper triangular matrix}
\usage{
full2sparse(mat)
}
\arguments{
\item{mat}{A matrix. Must have column names equal to the start location for
each bin. i.e. for a 6x6 Hi-C matrix where the first region starts at 0 kb and
the final region starts at 500KB and the resolution is 100kb, the column names
of the matrix should be as follows:
colnames(mat) = c(0, 100000, 200000, 300000, 400000, 500000)}
}
\value{
A sparse upper triangular matrix.
}
\description{
Transfrom a full Hi-C contact matrix to a sparse upper triangular matrix
}
\examples{
m <- matrix(1:100, 10, 10)
colnames(m) <- 1:10
sparse <- full2sparse(m)
sparse

}
