% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_distance_summary.R
\name{plot_distance_summary}
\alias{plot_distance_summary}
\title{Generate the plot based on distance output}
\usage{
plot_distance_summary(distances, type_of_value = "absolute")
}
\arguments{
\item{distances}{dataframes output from \code{\link{distance_summary}}}

\item{type_of_value}{an element from: absolute, by_int_type, by_total}
}
\value{
list with the plots
}
\description{
This function plots the distances by different approaches for the output of distance_summary
}
\details{
The type_of_value argument could be: Absolute: plots the Absolute number of interactions. By_int_type: plots the number of interactions divided by the total number of interactions of each type. By_total: plots the number of interactions divided by the total number of interactions
}
\examples{
ibed1 <- system.file("extdata", "ibed1_example.zip", package = "HiCaptuRe")
interactions1 <- load_interactions(ibed1, select_chr = "19")
df <- distance_summary(interactions = interactions1)
plots <- plot_distance_summary(distances = df)

}
