% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersect_interactions.R
\name{intersect_interactions}
\alias{intersect_interactions}
\title{Computes the intersect between a list of interactions objects}
\usage{
intersect_interactions(interactions_list, distance.boxplot = FALSE, ...)
}
\arguments{
\item{interactions_list}{list of HiCaptuRe objects from \code{\link{load_interactions}}}

\item{distance.boxplot}{logical, by default FALSE, plot a boxplot of log10 distance of each intersection in the upset plot}

\item{...}{extra arguments for UpSetR}
}
\value{
A list with:
\describe{
  \item{intersections}{A named list of intersected HiCaptuRe objects}
  \item{upset}{An UpSetR plot}
  \item{venn}{A ggVennDiagram plot (NULL if > 7 sets)}
}
}
\description{
This function computes all the possible intersects for a given list of HiCaptuRe objects
}
\examples{
ibed1 <- system.file("extdata", "ibed1_example.zip", package = "HiCaptuRe")
interactions1 <- load_interactions(ibed1, select_chr = "19")
ibed2 <- system.file("extdata", "ibed2_example.zip", package = "HiCaptuRe")
interactions2 <- load_interactions(ibed2, select_chr = "19")
interactions_list <- list(ibed1 = interactions1, ibed2 = interactions2)
intersection <- intersect_interactions(interactions_list = interactions_list)

}
