% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_interactions.R
\name{annotate_interactions}
\alias{annotate_interactions}
\title{Annotates HiCaptuRe object from load_interactions}
\usage{
annotate_interactions(interactions, annotation, ...)
}
\arguments{
\item{interactions}{HiCaptuRe object from \code{\link{load_interactions}}}

\item{annotation}{full path to annotations file or a dataframe with 5 columns: chr, start, end, fragmentID, annotation}

\item{...}{additional parameters for fread}
}
\value{
HiCaptuRe object annotated, with columns bait_1 and bait_2 substituted based on the given annotation
}
\description{
This function annotate a HiCaptuRe object from load_interactions, based on a given annotations file
}
\examples{
annotation <- system.file("extdata", "annotation_example.txt", package = "HiCaptuRe")
ibed1 <- system.file("extdata", "ibed1_example.zip", package = "HiCaptuRe")
interactions <- load_interactions(ibed1, select_chr = "19")
interactions <- annotate_interactions(interactions = interactions, annotation = annotation)

}
