% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_hicpro_matrix_counts.R
\name{add_hicpro_matrix_counts}
\alias{add_hicpro_matrix_counts}
\title{add_hicpro_matrix.counts}
\usage{
add_hicpro_matrix_counts(
  gi_list,
  absfile_path,
  matrixfile_path,
  chrs = NULL,
  add_inter = FALSE
)
}
\arguments{
\item{gi_list}{valid, uniformly binned gi_list instance. 
See \code{?gi_list_validate} and \code{gi_list_binsize_detect} for details.}

\item{absfile_path}{absfile BED out of HiC-Pro (e.g., 'rawdata_10000_abs.bed')}

\item{matrixfile_path}{matrix count file out of HiC-Pro (e.g.,
'rawdata_10000.matrix')}

\item{chrs}{a subset of chromosomes' e.g., c('chr21','chr22'). Defaults
to all chromosomes in the \code{gi_list} instance.}

\item{add_inter}{Interchromosomal interaction counts added as a 1D feature
named 'inter' on regions metadata handle of each gi_list element (e.g., 
\code{gi_list[[1]]@regions@elementMetadata} or not;
default FALSE}
}
\value{
\code{gi_list} instance with counts on the metadata (e.g., 
\code{mcols(gi_list[[1]])} handle on each list element, and 'inter' on 
regions metadata handle of each element if \code{add_inter=TRUE}.
}
\description{
This function converts HiC-Pro matrix and bed outputs into a gi_list instance.
}
