% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFASTA.R
\name{getFASTA}
\alias{getFASTA}
\title{Fetch FASTA Sequence from the UniProt Database}
\usage{
getFASTA(uniprot.id, filename = "FASTA.RData", path = "FASTASeq")
}
\arguments{
\item{uniprot.id}{A character vector of UniProt identifiers.}

\item{filename}{A character string, indicating the output filename as an
RData object to store the retrieved sequences.}

\item{path}{A character string indicating the path to the project
directory that contains the interaction data.
If the directory is missing, it will be stored in the current directory.
Default is FASTASeq.}
}
\value{
A list containing protein FASTA sequences.
}
\description{
This function retrieves protein sequences in FASTA format
directly from the UniProt database via UniProt protein IDs. This function
also checks if the amino-acid composition of protein sequences
is in the 20 default types.
}
\details{
getFASTA
}
\examples{
# get fasta sequences for three proteins of SARS-Cov-2
local = tempdir()
uniprot.id <- c("P0DTC4", "P0DTC5", "P0DTC9")
fasta_df <- getFASTA(uniprot.id, filename = 'FASTA.RData', path = local)
head(fasta_df)
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
