% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateF.R
\name{calculateF}
\alias{calculateF}
\title{Calculate F1 or F2 Descriptors}
\usage{
calculateF(x, type = c("F1", "F2"))
}
\arguments{
\item{x}{A data.frame containing gene/protein names and their
fasta sequences.}

\item{type}{The descriptor type:
\code{F1} or \code{F2}.}
}
\value{
A length 20 named vector for the data input.
}
\description{
This function calculates F1 or F2 descriptors:
\itemize{
\item \code{F1} - sum of squared length of Single Amino Acid Repeats
(SARs) in the entire protein sequence.
\item \code{F2} - maximum of the sum of Single Amino Acid Repeats (SARs)
in a window of 6 residues.
}
}
\details{
calculateF
}
\examples{
data(UP000464024_df)
x_df <- calculateF(UP000464024_df, type = "F1")
head(x_df, n = 2L)
}
\references{
Alguwaizani, S., Park, B., Zhou, X., Huang, D.-S., and Han, K. (2018).
Predicting interactions between virus and host proteins using repeat
patterns and composition of amino acids.
\emph{J. Healthc. Eng.} 2018.
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
