% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateAutocor.R
\name{calculateAutocor}
\alias{calculateAutocor}
\title{Calculate Autocorrelation Descriptors}
\usage{
calculateAutocor(
  x,
  target.props = c("CIDH920105", "BHAR880101", "CHAM820101", "CHAM820102",
    "CHOC760101", "BIGC670101", "CHAM810101", "DAYM780201"),
  nlag = 30L,
  type = c("moran", "geary", "moreaubroto")
)
}
\arguments{
\item{x}{A data.frame containing gene/protein names and their
fasta sequences.}

\item{target.props}{A character vector, specifying the
accession number of the target properties.
8 properties are used by default, as listed below:
\describe{
\item{AccNo. CIDH920105}{Normalized average hydrophobicity scales
 (Cid et al., 1992)}
\item{AccNo. BHAR880101}{Average flexibility indices
(Bhaskaran-Ponnuswamy, 1988)}
\item{AccNo. CHAM820101}{Polarizability parameter
(Charton-Charton, 1982)}
\item{AccNo. CHAM820102}{Free energy of solution in water, kcal/mole
(Charton-Charton, 1982)}
\item{AccNo. CHOC760101}{Residue accessible surface area in
 tripeptide (Chothia, 1976)}
\item{AccNo. BIGC670101}{Residue volume (Bigelow, 1967)}
\item{AccNo. CHAM810101}{Steric parameter (Charton, 1981)}
\item{AccNo. DAYM780201}{Relative mutability (Dayhoff et al., 1978b)}}}

\item{nlag}{Maximum value of the lag parameter. Default is \code{30}.}

\item{type}{The autocorrelation type:
\code{moran}, \code{geary}, or \code{moreaubroto}.}
}
\value{
A length \code{nlag} named vector for data input.
}
\description{
This function calculates autocorrelation descriptors:
\itemize{
\item \code{moran} - moran autocorrelation,
(Dim: \code{length(target.props) * nlag}).
\item \code{geary} - geary autocorrelation,
(Dim: \code{length(target.props) * nlag}).
\item \code{moreaubroto} - moreau-broto autocorrelation,
(Dim: \code{length(target.props) * nlag}).
}
}
\details{
calculateAutocor
}
\examples{
data(UP000464024_df)
x_df <- calculateAutocor(UP000464024_df,type = 'moran')
head(x_df, n = 2L)
}
\references{
AAindex: Amino acid index database.
\url{http://www.genome.ad.jp/dbget/aaindex.html}

Feng, Z.P. and Zhang, C.T. (2000)
Prediction of membrane protein types based on the hydrophobic
index of amino acids.
\emph{Journal of Protein Chemistry}, 19, 269-275.

Horne, D.S. (1988)
Prediction of protein helix content from
an autocorrelation analysis of sequence hydrophobicities.
\emph{Biopolymers}, 27, 451-477.

Sokal, R.R. and Thomson, B.A. (2006)
Population structure inferred by local spatial autocorrelation:
an Usage from an Amerindian tribal population.
\emph{American Journal of Physical Anthropology}, 129, 121-131.
}
\author{
Matineh Rahmatbakhsh <\email{matinerb.94@gmail.com}>,
        Nan Xiao
}
