% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml.R
\name{hpaXmlTissueExpr}
\alias{hpaXmlTissueExpr}
\title{Extract tissue expression details}
\usage{
hpaXmlTissueExpr(importedXml)
}
\arguments{
\item{importedXml}{Input an xml document object resulted from a
\code{hpaXmlGet()} call.}
}
\value{
This function returns a list of tibbles, each for an antibody. Each
  tibble contains information about all individual samples and their
  staining. Due to the variation in amount of information available for these
  samples, the number of columns differs, but the tibble essentially
  includes: patientId, age, sex, staining, intensity, quantity, location,
  imageUrl, snomedCode, and tissueDescription. The last two items may have
  more than one column each.
}
\description{
Extract tissue expression information for each sample and url to download
images from imported xml document resulted from \code{hpaXmlGet()}. It is
important to note that the data that HPA provides on their website and
through xml files are not one-to-one equivalents. For example, xml files
usually only provide one of the two histology image for each patient.
}
\examples{
\donttest{
  GCH1xml <- hpaXmlGet('ENSG00000131979')
  hpaXmlTissueExpr(GCH1xml)
}

}
\seealso{
Other xml functions: 
\code{\link{hpaXml}()},
\code{\link{hpaXmlAntibody}()},
\code{\link{hpaXmlGet}()},
\code{\link{hpaXmlProtClass}()},
\code{\link{hpaXmlTissueExprSum}()}
}
\concept{xml functions}
