% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml.R
\name{hpaXmlProtClass}
\alias{hpaXmlProtClass}
\title{Extract protein classes}
\usage{
hpaXmlProtClass(importedXml)
}
\arguments{
\item{importedXml}{Input an xml document object resulted from a
\code{hpaXmlGet()} call.}
}
\value{
This function return a tibble of 4 columns.
}
\description{
Extract protein class information from imported xml document resulted from
\code{hpaXmlGet()}.  It is important to note that the data that HPA provides
on their website and through xml files are not one-to-one equivalents.
}
\examples{
  GCH1xml <- hpaXmlGet('ENSG00000131979')
  hpaXmlProtClass(GCH1xml)

}
\seealso{
Other xml functions: 
\code{\link{hpaXml}()},
\code{\link{hpaXmlAntibody}()},
\code{\link{hpaXmlGet}()},
\code{\link{hpaXmlTissueExpr}()},
\code{\link{hpaXmlTissueExprSum}()}
}
\concept{xml functions}
