% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml.R
\name{hpaXmlGet}
\alias{hpaXmlGet}
\title{Download and import xml file}
\usage{
hpaXmlGet(targetEnsemblId, version = "latest")
}
\arguments{
\item{targetEnsemblId}{A string of one ensembl ID, start with ENSG. For
example \code{'ENSG00000131979'}. You can also use HGNC gene symbol and it
will be converted to ensembl id.}

\item{version}{A string indicate which version to be downloaded. Possible
value: \itemize{ \item \code{'latest'}: Download latest version. \item
\code{'v?'} with '?' is a integer: Download a specific version of the
dataset. For example: 'v18' download version 18. Currently support version
13 and above. }}
}
\value{
This function return an object of class \code{"xml_document"
  "xml_node"} containing the content of the imported XML file. (See
  documentations for package \code{xml2} for more information.)
}
\description{
Download and import individual xml file for a specified protein. This
function calls \code{xml2::read_xml()} under the hood.  It is important to
note that the data that HPA provides on their website and through xml files
are not one-to-one equivalents.
}
\examples{
  GCH1xml <- hpaXmlGet('ENSG00000131979')

}
\seealso{
Other xml functions: 
\code{\link{hpaXml}()},
\code{\link{hpaXmlAntibody}()},
\code{\link{hpaXmlProtClass}()},
\code{\link{hpaXmlTissueExpr}()},
\code{\link{hpaXmlTissueExprSum}()}
}
\concept{xml functions}
