% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{hpaVisSubcell}
\alias{hpaVisSubcell}
\title{Visualize subcellular location data}
\usage{
hpaVisSubcell(
  data = NULL,
  targetGene = NULL,
  reliability = c("enhanced", "supported", "approved", "uncertain"),
  color = c("#FCFDBF", "#8C2981"),
  customTheme = FALSE
)
}
\arguments{
\item{data}{Input the list object generated by \code{hpa_download()} or
\code{hpa_subset()}. Require the \code{subcellular_location} dataset. Use
HPA histology data (built-in) by default.}

\item{targetGene}{Vector of strings of HGNC gene symbols. By default it is
set to \code{c('TP53', 'EGFR', 'CD44', 'PTEN')}. You can also mix
HGNC gene symbols and ensemnl ids (start with ENSG) and they will be
converted to HGNC gene symbols.}

\item{reliability}{Vector of string indicate which reliability scores you want to plot. The
default is everything \code{c("enhanced", "supported", "approved",
"uncertain")}.}

\item{color}{Vector of 2 colors used to depict if the protein expresses in a
location or not.}

\item{customTheme}{Logical argument. If \code{TRUE}, the function will return
a barebone ggplot2 plot to be customized further.}
}
\value{
This function will return a ggplot2 plot object, which can be further
  modified if desirable. The subcellular location data is visualized as a
  tile graph, in which the x axis includes the inquired proteins and the y
  axis contain the subcellular locations.
}
\description{
Visualize the the confirmed subcellular locations of genes of interest.
}
\examples{
  data("hpa_histology_data")
  geneList <- c('TP53', 'EGFR', 'CD44', 'PTEN', 'IDH1', 'IDH2', 'CYCS')

  ## A typical function call
  hpaVisSubcell(data=hpa_histology_data,
                  targetGene=geneList)

}
\seealso{
Other visualization functions: 
\code{\link{hpaVis}()},
\code{\link{hpaVisPatho}()},
\code{\link{hpaVisTissue}()}
}
\concept{visualization functions}
