% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitope_finding.R
\name{findBlocksProbeT}
\alias{findBlocksProbeT}
\title{Find Blocks of consecutive probes}
\usage{
findBlocksProbeT(
  probes,
  protein_tiling,
  proteins = getProteinLabel(probes),
  starts = getProteinStart(probes)
)
}
\arguments{
\item{probes}{vector of probe identifiers of the format
c(Prot1;1, ... Prot1;10)}

\item{protein_tiling}{tiling of the associated proteins}

\item{proteins}{associated proteins to probes (cache speed up)}

\item{starts}{associated starts from probes (cache speed up)}
}
\value{
data.frame with the Protein, Start, Stop, and Number.Of.Probes
columns
}
\description{
This function will find blocks of consecutive probes within the passed
probe parameter
}
\examples{
findBlocksProbeT(c("A;1", "A;2", "A;3", "B;2", "B;3", "C;10", "A;5", "A;6"))
}
