% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcProbePvaluesW.R
\name{calcProbePValuesWUnpaired}
\alias{calcProbePValuesWUnpaired}
\title{Calculate Probe p-values using a two-sample wilcoxon test}
\usage{
calcProbePValuesWUnpaired(probe_mat, colData_in, exact = NULL, abs_shift = 0)
}
\arguments{
\item{probe_mat}{numeric matrix or data.frame of values}

\item{colData_in}{design data.frame}

\item{exact}{a logical indicating whether an exact p-value should be
computed (see wilcox.test for details)}

\item{abs_shift}{absolute shift to use when calculating p-values}
}
\value{
matrix of p-values on the post columns defined in the colData matrix
}
\description{
Calculate Probe p-values using a two-sample wilcoxon test
}
\examples{
data(heffron2021_wuhan)
colData_wu <- colData(heffron2021_wuhan)
pval_res <- calcProbePValuesWUnpaired(assay(heffron2021_wuhan), colData_wu)
}
