### PURPOSE: Obtain node and edge permutation test p values 
### INPUT 1: act.mat = adjacency matrix whose nodes/edges are to be permuted
### INPUT 2: nonact.mat = adjacency matrix whose nodes/edges are not permuted
### INPUT 3: Number of realizations generated by random permutation of nodes or
###          edges
### OUTPUT:  (P value from Edge permutation, P value from Node permutation)	 

getpvalue <- function(act.mat, nonact.mat, num.iterations=1000)
{
	obs.rand.edges <- c()
	obs.rand.nodes <- c()

	intmat <- nonact.mat*act.mat
	obs.data <- sum(intmat)/2

	for (i in 1:num.iterations)
	{

		##### Permuting the edges
		litmatPE <- permEdgesM2M(act.mat)
		intmatPE <- nonact.mat*litmatPE
		obs.rand.edges <- c(obs.rand.edges, sum(intmatPE)/2)
		
		##### Permuting the nodes 
		litmatPN <- permNodesM2M(act.mat)
		intmatPN <- nonact.mat*litmatPN
		obs.rand.nodes <- c(obs.rand.nodes, sum(intmatPN)/2)
		
	}

	p.value <- c(sum(obs.rand.edges >= obs.data)/num.iterations, sum(obs.rand.nodes >= obs.data)/num.iterations)
	return(p.value) 
}

