% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bn_tabu_gen_1.R
\name{bn_tabu_gen}
\alias{bn_tabu_gen}
\title{Uses tabu search algorithm to learn the structure of discretized data.}
\usage{
bn_tabu_gen(
  Auto_WGCNA_OUTPUT,
  whitelist = NULL,
  blacklist = NULL,
  score = "bde",
  tabu = 50,
  iss = 10,
  cluster = NULL,
  debug = TRUE,
  bootstraps_replicates = 500
)
}
\arguments{
\item{Auto_WGCNA_OUTPUT}{an R object generated by Auto_WGCNA and 
discretized using the Data_Prep function.}

\item{whitelist}{a data frame with two columns (optionally labeled "from" and
    "to"), containing a set of arcs to be included in the graph.}

\item{blacklist}{a data frame with two columns (optionally labeled "from" and
    "to"), containing a set of arcs not to be included in the graph.}

\item{score}{character string indicating the score used for structure 
learning. If "bde" (default), prior is set to "uniform".  
If bds is used, the prior is set to "marginal".}

\item{tabu}{a positive integer number, the length of the tabu list used in the
    \code{tabu} function.}

\item{iss}{the imaginary sample size, used by the Bayesian 
Dirichlet scores (bde and bds)
It is also known as “equivalent sample size”.
The default value is equal to 10.}

\item{cluster}{an optional cluster object from package \pkg{parallel}.}

\item{debug}{a boolean value. If \code{TRUE} a lot of debugging output is
    printed; otherwise the function is completely silent.}

\item{bootstraps_replicates}{an integer for the number of 
bootstraps_replicates
used for structure learning. Default value is 500}
}
\value{
The learned bayesian network
}
\description{
Uses tabu search algorithm to learn the structure of discretized data.
}
\examples{
GMIC_Builder_disc_dir<-system.file("extdata", "GMIC_Builder_disc.Rdata", 
package = "GmicR", mustWork = TRUE)
load(GMIC_Builder_disc_dir)

no_cores<-1
cl<-parallel::makeCluster(no_cores)

GMIC_net<-bn_tabu_gen(GMIC_Builder_disc,
cluster = cl,
bootstraps_replicates = 50, score = "bds")
parallel::stopCluster(cl)
}
\seealso{
\code{\link[bnlearn]{arc.strength}}

\code{\link[bnlearn]{hc}}

\code{\link[bnlearn]{score}}
}
