% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Module_annotation.R
\name{Query_Prep}
\alias{Query_Prep}
\title{Query Prep}
\usage{
Query_Prep(
  Auto_WGCNA_OUTPUT,
  numGenes = 500,
  Find_hubs = FALSE,
  nThreads = NULL,
  calculate_intramodularConnectivity = TRUE
)
}
\arguments{
\item{Auto_WGCNA_OUTPUT}{R object generated by Auto_WGCNA function.}

\item{numGenes}{integer indicating the number of random genes to test 
for hub gene detection.
Default is 500.}

\item{Find_hubs}{logical value. If TRUE, module hub genes will be returned. 
If FALSE (default),
intramodularConnectivity will be returned without hub gene identification.}

\item{nThreads}{ non-negative integer specifying the number of parallel threads to be used by certain
parts of correlation calculations. This option only has an effect on systems on which a POSIX thread
library is available (which currently includes Linux and Mac OSX, but excludes Windows). 
If zero, the number of online processors will be used if it can be determined dynamically, otherwise
correlation calculations will use 2 threads. }

\item{calculate_intramodularConnectivity}{a logical value. If TRUE 
(default), the intramodularConnectivity
will be caluculated using the intramodularConnectivity function from WGCNA. 
If FALSE, a table of modules
and genes will be returned without intramodularConnectivity values.}
}
\value{
a data.frame detailing the gene symbols for each module. Gene
intramodularConnectivity may also be returned. If detected, hub genes are 
annotated.
}
\description{
Query Prep
}
\examples{
GMIC_Builder_dir<-system.file("extdata", "GMIC_Builder.Rdata", 
package = "GmicR", mustWork = TRUE)
load(GMIC_Builder_dir)
GMIC_Builder<-Query_Prep(GMIC_Builder,  Find_hubs = TRUE)
head(GMIC_Builder$Query)
}
