% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBthDE.R
\docType{methods}
\name{contrastNBth}
\alias{contrastNBth}
\alias{contrastNBth,list-method}
\title{Generate list of Wald test inference results on user specified contrasts}
\usage{
contrastNBth(object, ...)

\S4method{contrastNBth}{list}(
  object,
  test = c("two-sided", ">", "<"),
  method = diag(1, ncol(object$X)),
  baseline = rep(0, ncol(method))
)
}
\arguments{
\item{object}{DE model, output by fitNBthDE or fitNBthmDE}

\item{...}{additional argument list that might be used}

\item{test}{type of statistical test, choose from c("two-sided", ">", "<")}

\item{method}{contrasts methods, only matrix of contrast vector is allowed for now, default=diag(1,ncol(object$X)), i.e. testing the regression coefficients}

\item{baseline}{testing baseline, default=0.}
}
\value{
\itemize{
  \item estimate, contrasts estimate
  \item wald_stat, Wald test statistics
  \item p_value, p value of Wald test
  \item se, standard error
}
}
\description{
Generate list of Wald test inference results including contrast estimation and p value
}
\examples{
data(NBthmDEmod2)
coeff <- contrastNBth(NBthmDEmod2)
}
