% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggreprobe.R
\docType{methods}
\name{aggreprobe}
\alias{aggreprobe}
\alias{aggreprobe,NanoStringGeoMxSet-method}
\alias{aggreprobe,matrix-method}
\title{Generate aggregated counts of probes for the same target}
\usage{
aggreprobe(object, ...)

\S4method{aggreprobe}{NanoStringGeoMxSet}(
  object,
  split,
  use = c("score", "cor", "both"),
  corcutoff = 0.85,
  ...
)

\S4method{aggreprobe}{matrix}(
  object,
  probenames,
  featurenames,
  negmod,
  use = c("score", "cor", "both"),
  corcutoff = 0.85,
  ...
)
}
\arguments{
\item{object}{matrix of probes}

\item{...}{additional argument list that might be used}

\item{split}{indicator variable on whether it is for multiple slides (Yes, TRUE; No, FALSE)}

\item{use}{the method to determine outliers including score, cor, and both}

\item{corcutoff}{the cutoff value for correlation}

\item{probenames}{vector of names of probe}

\item{featurenames}{vector of names of features each probe corresponding to}

\item{negmod}{Poisson Background model object for negative probes}
}
\value{
\itemize{
  \item remain, the list of remaining probes of targets
  \item probenum, numerical vector of probe numbers of targets
  \item featuremat, the matrix of features
}

\itemize{
  \item remain, the list of remaining probes of targets
  \item probenum, numerical vector of probe numbers of targets
  \item featuremat, the matrix of features
}
}
\description{
Generate Generate aggregated counts of probes for the same target, based on their score test results or correlation

Generate Generate aggregated counts of probes for the same target, based on their score test results or correlation
}
\examples{
data("demoData")
demoData <- aggreprobe(demoData, use = "cor")
}
