% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawWordcloud.R
\name{meshTable}
\alias{meshTable}
\title{Build a two-column word/frequency table}
\usage{
meshTable(
  RAVmodel,
  ind,
  rm.noise = NULL,
  weighted = TRUE,
  filterMessage = TRUE
)
}
\arguments{
\item{RAVmodel}{A PCAGenomicSignatures object}

\item{ind}{An index of RAV}

\item{rm.noise}{An integer. Under the default (\code{rm.noise=NULL}), if
cluster size (= \code{s}) is smaller than 8, \code{rm.noise = floor(s*0.5)}.
For clusters with >= 8 PCs, \code{rm.noise = 4}. If \code{rm.noise = 0}, all
the MeSH terms in RAV will be used to draw wordcloud.}

\item{weighted}{A logical. If \code{TRUE}, MeSH terms from each study are
weighted based on the variance explained by the principle component of the
study contributing a give RAV. Default is \code{TRUE}.}

\item{filterMessage}{A logical. Under the default \code{TRUE}, any output
RAV belong to the filtering list will give a message. Silence this message
with \code{filterMessage=FALSE}. You can check the filter list using
\code{data("filterList")}.}
}
\value{
A table with two columns, \code{word} and \code{freq}. MeSH terms in
the defined RAV (by \code{ind} argument) is ordered based on their frequency.
}
\description{
Build a two-column word/frequency table
}
\examples{
data(miniRAVmodel)
meshTable(miniRAVmodel,1139)

}
