% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMetadata.R
\name{getRAVInfo}
\alias{getRAVInfo}
\title{Extract information on a specific RAV}
\usage{
getRAVInfo(RAVmodel, ind)
}
\arguments{
\item{RAVmodel}{A PCAGenomicSignatures object}

\item{ind}{An index of RAV}
}
\value{
A list with four elements: clusterSize, silhouetteWidth,
enrichedPathways (the number of enriched pathways), and members.
The 'members' is the summary table of PCs in RAV, containing three columns:
studyName, PC, and Variance explained (%).
}
\description{
Extract information on a specific RAV
}
\examples{
data(miniRAVmodel)
getRAVInfo(miniRAVmodel, ind = 438)

}
