% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getModel.R
\name{getModel}
\alias{getModel}
\title{Download a PCAGenomicSignatures model}
\usage{
getModel(prior = c("C2", "PLIERpriors"), version = "latest", load = TRUE)
}
\arguments{
\item{prior}{The name of gene sets used to annotate PCAGenomicSignatures.
Currently  there are two available options.
\itemize{
    \item \code{C2} : MSigDB C2 (curated gene sets)
    \item \code{PLIERpriors} : bloodCellMarkersIRISDMAP, svmMarkers, and
    canonicalPathways
}}

\item{version}{Default is \code{latest}. Available versions are listed in
\code{version} column of \code{\link{[GenomicSuperSignature]availableRAVmodel()}} output.}

\item{load}{Default is \code{TRUE}. If it's set to \code{FALSE}, the models
are just downloaded to cache but not loaded into memory.}
}
\value{
File cache location or PCAGenomicSignatures object loaded from it.
}
\description{
Download a PCAGenomicSignatures model
}
\examples{
z = getModel("C2")

}
