% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawingFunctions.R
\name{overlap_triple}
\alias{overlap_triple}
\title{Plot three-sets Venn diagram}
\usage{
overlap_triple(atriple, overlap_fun, title = NULL)
}
\arguments{
\item{atriple}{a list of three vectors}

\item{overlap_fun}{the name of the function that defines overlap, depending
on the type of object in the vectors. For GRanges, use
\code{\link{filter_by_overlaps_stranded}} or
\code{\link{filter_by_nonoverlaps_stranded}}, for gene names, use intersect.}

\item{title}{main title of the figure}
}
\value{
a VennDiagram object
}
\description{
This is a helper function for Venn diagram plot. A Venn diagram
is plotted as output. For GRanges, as A overlap B may not be the same as B
overlap A, the order of GRanges in a list matters, certain order may produce
an error.
}
\examples{

test_list <- list(A = c(1, 2, 3, 4, 5), B = c(4, 5, 7), C = c(1, 3))
overlap_triple(test_list, intersect, title = "test")

## GRanges overlap
query <- GRanges("chr19",
    IRanges(rep(c(10, 15), 2), width = c(1, 20, 40, 50)),
    strand = c("+", "+", "-", "-")
)

subject1 <- GRanges("chr19",
    IRanges(rep(c(13, 150), 2), width = c(10, 14, 20, 28)),
    strand = c("+", "-", "-", "+")
)

subject2 <- GRanges("chr19",
    IRanges(rep(c(13, 50), 2), width = c(10, 14, 20, 21)),
    strand = c("+", "-", "-", "+")
)

overlap_triple(
    list(subject1 = subject1, subject2 = subject2, query = query),
    filter_by_overlaps_stranded
)

}
\author{
Shuye Pu
}
