% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HandleDataMatrix.R
\name{gr2df}
\alias{gr2df}
\title{Convert GRanges to dataframe}
\usage{
gr2df(gr)
}
\arguments{
\item{gr}{a GRanges object}
}
\value{
a dataframe
}
\description{
Convert a GRanges object with meta data columns to a dataframe,
with the first 6 columns corresponding those of BED6 format, and the meta
data as additional columns
}
\examples{
gr2 <- GenomicRanges::GRanges(c("chr1", "chr1"),
    IRanges::IRanges(c(7, 13), width = 3),
    strand = c("+", "-")
)
GenomicRanges::mcols(gr2) <- data.frame(
    score = c(0.3, 0.9),
    cat = c(TRUE, FALSE)
)
df2 <- gr2df(gr2)

}
\author{
Shuye Pu
}
