% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadData.R
\name{find_mate}
\alias{find_mate}
\title{Find wig/bw file for the negative strand}
\usage{
find_mate(inputFile, verbose = FALSE)
}
\arguments{
\item{inputFile}{path to a .wig/bw file, presumably for positive strand}

\item{verbose}{logical, whether to output additional information}
}
\value{
path to the negative .wig/bw file or NULL
}
\description{
Find the file name of the negative strand, if a .wig/bw file for
positive strand if provided, by looking for file names with one character
difference. If no negative strand file is found, assume the input .wig/bw
file is non-stranded
}
\examples{

queryFile <- system.file("extdata", "test_wig_chr19_+.wig",
    package = "GenomicPlot"
)
names(queryFile) <- "test_wig"

out <- GenomicPlot:::find_mate(inputFile = queryFile, verbose = TRUE)

}
\author{
Shuye Pu
}
\keyword{internal}
