% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadData.R
\name{setImportParams}
\alias{setImportParams}
\title{set parameters for \code{handle_input} function}
\usage{
setImportParams(
  offset = 0,
  fix_width = 0,
  fix_point = "start",
  norm = FALSE,
  useScore = FALSE,
  outRle = TRUE,
  useSizeFactor = FALSE,
  saveRds = FALSE,
  genome = "hg19",
  val = 4,
  skip = 0,
  chr = NULL
)
}
\arguments{
\item{offset}{an integer, -1 indicating the bam reads should be shrunk to the
-1 position at the 5'end of the reads, which corresponds to the cross link
site in iCLIP.}

\item{fix_width}{an integer, for bam file, defines how long the reads should
be extended from the start position, ignored when offset is not 0; for bed
files, defines the width of each interval centering on the `fix_point`.}

\item{fix_point}{a string in c("start", "end", "center") denoting the anchor
point for extension, ignored when offset is not 0.}

\item{norm}{logical, indicating whether the output RleList should be
normalized to RPM using library sizes.}

\item{useScore}{logical, indicating whether the 'score' column of the bed
file should be used in calculation of coverage.}

\item{outRle}{logical, indicating whether the output should be RleList
objects or GRanges objects.}

\item{useSizeFactor}{logical, indicating whether the library size should be
adjusted with a size factor, using the 'calcNormFactors' function in the
edgeR package, only applicable to ChIPseq data.}

\item{saveRds}{logical, indicating whether the results of handle_input should
be saved for fast reloading}

\item{genome}{a string denoting the genome name and version.}

\item{val}{integer, indicating the column that will be used as score/value.
default 4 for bedGraph.}

\item{skip}{integer, indicating how many rows will be skipped before reading
in data, default 0.}

\item{chr}{a vector of string, denoting chromosomes to be included, like
c("chr1", "chr2", "chrX"), default NULL indicating all chromosomes will be
included.}
}
\value{
a list of nine elements
}
\description{
This function save as a template for setting up import
parameters for reading NGS data, it provides default values for each
parameter.
}
\examples{
importParams1 <- setImportParams()
importParams2 <- setImportParams(offset = -1, saveRds = TRUE)

}
\author{
Shuye Pu
}
