% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_start_end.R
\name{plot_start_end}
\alias{plot_start_end}
\title{Plot signals around the start and the end of genomic features}
\usage{
plot_start_end(
  queryFiles,
  inputFiles = NULL,
  centerFiles,
  txdb = NULL,
  importParams = NULL,
  binSize = 10,
  insert = 0,
  verbose = FALSE,
  ext = c(-500, 100, -100, 500),
  hl = c(-50, 50, -50, 50),
  stranded = TRUE,
  scale = FALSE,
  smooth = FALSE,
  rmOutlier = 0,
  outPrefix = NULL,
  transform = NA,
  shade = TRUE,
  Ylab = "Coverage/base/gene",
  hw = c(8, 8),
  nc = 2
)
}
\arguments{
\item{queryFiles}{a vector of sample file names. The file should be in .bam,
.bed, .wig or .bw format, mixture of formats is allowed}

\item{inputFiles}{a vector of input sample file names. The file should be in
.bam, .bed, .wig or .bw format, mixture of formats is allowed}

\item{centerFiles}{bed files that define the custom features, or features in
c("utr3", "utr5", "cds", "intron", "exon", "transcript", "gene"), multiple
features are allowed.}

\item{txdb}{a TxDb object defined in the GenomicFeatures package. Default
NULL, needed only when genomic features are used in the place of centerFiles.}

\item{importParams}{a list of parameters for \code{\link{handle_input}}}

\item{binSize}{an integer defines bin size for intensity calculation}

\item{insert}{an integer specifies the length of the center regions to be
included, in addition to the start and end of the feature}

\item{verbose}{logical, whether to output additional information (including
data used for plotting or statistical test results)}

\item{ext}{a vector of four integers defining upstream and downstream
boundaries of the plot window, flanking the start and end of features}

\item{hl}{a vector of four integers defining upstream and downstream
boundaries of the highlight window, flanking the start and end of features}

\item{stranded}{logical, indicating whether the strand of the feature should
be considered}

\item{scale}{logical, indicating whether the score matrix should be scaled to
the range 0:1, so that samples with different baseline can be compared}

\item{smooth}{logical, indicating whether the line should smoothed with a
spline smoothing algorithm}

\item{rmOutlier}{a numeric value serving as a multiplier of the MAD in Hampel
filter for outliers identification, 0 indicating not removing outliers. For
Gaussian distribution, use 3, adjust based on data distribution}

\item{outPrefix}{a string specifying output file prefix for plots
(outPrefix.pdf)}

\item{transform}{a string in c("log", "log2", "log10"), default = NA,
indicating no transformation of data matrix}

\item{shade}{logical indicating whether to place a shaded rectangle around
the point of interest}

\item{Ylab}{a string for y-axis label}

\item{hw}{a vector of two elements specifying the height and width of the
output figures}

\item{nc}{integer, number of cores for parallel processing}
}
\value{
a list of two objects, the first is a GRanges object, the second is
 a GRangesList object
}
\description{
Plot reads or peak Coverage/base/gene of samples given in the
query files around start and end of custom features. The upstream and
downstream windows can be given separately, within the window, a smaller
window can be defined to highlight region of interest. A line plot will be
displayed for both start and end of feature. If Input files are provided,
ratio over Input is computed and displayed as well.
}
\examples{

gtfFile <- system.file("extdata", "gencode.v19.annotation_chr19.gtf",
    package = "GenomicPlot"
)

txdb <- custom_TxDb_from_GTF(gtfFile, genome = "hg19")
bamQueryFiles <- system.file("extdata", "treat_chr19.bam",
    package = "GenomicPlot")
names(bamQueryFiles) <- "clip_bam"
bamInputFiles <- system.file("extdata", "input_chr19.bam",
                             package = "GenomicPlot")
names(bamInputFiles) <- "clip_input"

bamimportParams <- setImportParams(
    offset = -1, fix_width = 0, fix_point = "start", norm = TRUE,
    useScore = FALSE, outRle = TRUE, useSizeFactor = FALSE, genome = "hg19"
)

plot_start_end(
    queryFiles = bamQueryFiles,
    inputFiles = bamInputFiles,
    txdb = txdb,
    centerFiles = "intron",
    binSize = 10,
    importParams = bamimportParams,
    ext = c(-500, 200, -200, 500),
    hl = c(-100, 100, -100, 100),
    insert = 100,
    stranded = TRUE,
    scale = FALSE,
    smooth = TRUE,
    transform = "log2",
    outPrefix = NULL,
    nc = 2
)
}
\author{
Shuye Pu
}
