\name{GenomicOZone}
\alias{GenomicOZone}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Delineate outstanding genomic zones
}
\description{
  Delineate outstanding genomic zones along chromosomes such that genes within an outstanding zone have consistent activity patterns that are different across samples.
}
\usage{
  GenomicOZone(GOZ.ds)
}
\arguments{
  \item{GOZ.ds}{
    an object created by function \code{GOZDataSet}.
  }
}
\details{
  This is the most important function of the package. It integrates genome annotation, gene activity matrix preprocessing, chromosome clustering, and differential zone analysis.

  Genome annotation can be specified either by the user, or obtained from the R package \pkg{biomaRt} \insertCite{smedley2015biomart}{GenomicOZone} to access ensembl annotation databases \insertCite{zerbino2017ensembl}{GenomicOZone}.

  The function calls the weighted univariate clustering method \insertCite{wang2011ckmeans}{GenomicOZone} implemented in the \pkg{Ckmeans.1d.dp} package. If \code{ks} is specified, a fixed number of zones at each chromosome will be delineated. If \code{ks} is \code{NULL}, an optimal number of clusters at each chromosome will be determined by Bayesian information criterion.

  The function also conducts differential zone analysis by using one-way ANOVA \insertCite{chambers1992statistical}{GenomicOZone} based on gene ranks. Given \code{p}-value cutoff \code{alpha} and effect size threshold \code{min.effect.size}, outstanding genomic zones will be selected.

  Advanced differential zone analysis such as generalized linear modeling can be performed on the zone activity matrix using third-party software.  The zone activity matrix can be generated by auxiliary functions.
}
\value{
  an object which is the input object attached with intermediate and final results. Results can be accessed by calling several functions in \code{\link{extract_outputs}}. The results can be visualized by calling the functions in \code{\link{generate_plots}}.
}
\seealso{
See \code{\link{GOZDataSet}} for how to create the input list. See \code{\link{extract_outputs}} and \code{\link{generate_plots}} for how to access the results and generate visualizations.
}
\examples{
  # Create an example of GOZ.ds
  data <- matrix(c(1,5,2,6,5,1,6,2), ncol = 2, byrow = TRUE)
  rownames(data) <- paste("Gene", 1:4, sep='')
  colnames(data) <- paste("Sample", c(1:2), sep='')

  colData <- data.frame(Sample_name = paste("Sample", c(1:2), sep=''),
                        Condition = c("Cancer", "Normal"))

  design <- ~ Condition

  rowData.GRanges <- GRanges(seqnames = Rle(rep("chr1", 4)),
                             ranges = IRanges(start = c(1,2,3,4), end = c(5,6,7,8)))
  names(rowData.GRanges) <- paste("Gene", 1:4, sep='')

  ks <- c(2)
  names(ks) <- "chr1"

  GOZ.ds <- GOZDataSet(data, colData, design,
                       rowData.GRanges = rowData.GRanges,
                       ks = ks)
  ####

  # Run the zoing process
  GOZ.ds <- GenomicOZone(GOZ.ds)
  ####
}

\references{
  \insertAllCited{}
}
