% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenomicInteractions-class.R
\docType{class}
\name{GenomicInteractions-class}
\alias{GenomicInteractions-class}
\title{A S4 class to represent interactions between genomic regions.}
\description{
@slot metadata List, defaults to 'experiment_name' and 'description', inherited from S4Vectors::Vector
 @slot anchor_one,anchor_two GRanges. Set of anchors of interactions.
 @slot counts integer vector, contains raw counts
 @slot elementMetadata DataFrame
 
This class is used to store information on which genomic regions are
interacting with each other. Objects of this class contain information of
the genomic coordinates of the interacting regions and the strength of these
interactions, and associated metadata such as the name of the dataset and a
brief description of the dataset.  Interacting regions are stored as a pair
of GenomicRanges: each set of anchor regions is stored as a separate
GenomicRanges object, accessed by \code{getAnchorOne} and
\code{getAnchorTwo}.
}
\examples{

showClass('GenomicInteractions')
library(GenomicRanges)

anchor.one = GRanges(c('chr1', 'chr1', 'chr1', 'chr1'), IRanges(c(10, 20, 30, 20), width=5))
anchor.two = GRanges(c('chr1', 'chr1', 'chr1', 'chr2'), IRanges(c(100, 200, 300, 50), width=5))
interaction_counts = sample(1:10, 4)
test <- GenomicInteractions(anchor.one, anchor.two, counts=interaction_counts)

}
