% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectNodes.R
\name{detectNodes}
\alias{detectNodes}
\title{Detect the interaction node}
\usage{
detectNodes(interaction, pval_cutoff = 0.05, ...)
}
\arguments{
\item{interaction}{An object of \link[S4Vectors:Pairs-class]{Pairs} to
represent interactions.}

\item{pval_cutoff}{Cutoff P value for interaction node by Poisson distribution}

\item{...}{Not used.}
}
\value{
A list of interaction nodes with elements:
 node_connection, Pairs object represent interactions interacted with nodes;
 nodes, GRanges object represent regions with maximal interactions involved in nodes;
 node_regions, GRanges object represent regions interacted with nodes.
}
\description{
Define the interaction node from input Pairs.
}
\examples{
library(rtracklayer)
p <- system.file("extdata", "WT.2.bedpe",
                 package = "GenomicInteractionNodes")
interactions <- import(con=p, format="bedpe")
nodes <- detectNodes(interactions)
}
