% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specificity-plots.R
\name{plotSummarySignal}
\alias{plotSummarySignal}
\title{The function plotSummarySignal visualizes the signalSummaryMatrix obtained from
\code{calcSummarySignal}.}
\usage{
plotSummarySignal(
  signalSummaryList,
  plotType = "barPlot",
  metadata = NULL,
  colorColumn = NULL,
  filterGroupColumn = NULL,
  filterGroup = NULL
)
}
\arguments{
\item{signalSummaryList}{Output list from \code{calcSummarySignal} function.}

\item{plotType}{Options are: "jitter" - jitter plot with box plot on top,
"boxPlot" - box plot without individual points and outliers,
"barPlot" (default) - bar height represents the median signal value
for a given cell type, 
"violinPlot" - violin plot with medians.}

\item{metadata}{(optional) data.table used for grouping columns from 
'signalMatrix' into categories, that are then plotted with different colors. 
Must contain variable 'colName' that contains all the condition column names 
from 'signaMatrix'.}

\item{colorColumn}{(optional only if metadata provided) columns name from 
'metadata' table that will be used as grouping variable for coloring.}

\item{filterGroupColumn}{(optional only if metadata provided and 
'filterGroup' specified) allows user to plot specified subgroups only. 
String specifying the column name in 'metadata' from which groups will 
be filtered (groups are specified in as 'filterGroups)}

\item{filterGroup}{(optional only if 'metadata' and 'filterGroupColumn' 
provided) - string (or vector of strings) of groups from 
'filterGroupColumn' to be plottted.}
}
\value{
A ggplot object.
}
\description{
The function plotSummarySignal visualizes the signalSummaryMatrix obtained from
\code{calcSummarySignal}.
}
\examples{
signalSummaryList = calcSummarySignal(vistaEnhancers, exampleOpenSignalMatrix_hg19)
metadata = cellTypeMetadata
plotSignal = plotSummarySignal(signalSummaryList)

plotSignalTissueColor = plotSummarySignal(signalSummaryList = signalSummaryList, 
plotType = "jitter", metadata = metadata, colorColumn = "tissueType")

plotSignalFiltered = plotSummarySignal(signalSummaryList = signalSummaryList,
plotType = "violinPlot", metadata = metadata, colorColumn = "tissueType", 
filterGroupColumn = "tissueType", filterGroup = c("skin", "blood"))
}
