% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition-plots.R
\name{plotPartitions}
\alias{plotPartitions}
\title{Produces a barplot showing how query regions of interest are distributed
across a given partition list}
\usage{
plotPartitions(assignedPartitions, numbers = FALSE, stacked = FALSE)
}
\arguments{
\item{assignedPartitions}{A table holding the frequency of assignment to
each of the partitions. Produced by \code{calcPartitions}}

\item{numbers}{logical indicating whether raw overlaps should be
plotted instead of the default percentages}

\item{stacked}{logical indicating that data should be plotted as stacked
bar plot}
}
\value{
A ggplot object using a barplot to show the distribution
    of the query
 regions across a given partition list.
}
\description{
This function can be used to test a GRanges object against any arbitrary
list of genome partitions. The partition list is a priority-ordered list of
GRanges objects. Each region in the query will be assigned to a given
partition that it overlaps with the highest priority.
}
\examples{
p = calcPartitionsRef(vistaEnhancers, "hg19")
partPlot = plotPartitions(p)
partCounts = plotPartitions(p, numbers=TRUE)
partPlot = plotPartitions(p, stacked=TRUE)
}
