% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildReferenceData.R
\name{getChromSizesFromFasta}
\alias{getChromSizesFromFasta}
\title{Get gene models from a remote or local FASTA file}
\usage{
getChromSizesFromFasta(source, destDir = NULL, convertEnsemblUCSC = FALSE)
}
\arguments{
\item{source}{a string that is either a path to a
local or remote FASTA}

\item{destDir}{a string that indicates the path to the 
directory where the downloaded FASTA file should be stored}

\item{convertEnsemblUCSC}{a logical indicating whether Ensembl style 
chromosome annotation should be changed to UCSC style (add chr)}
}
\value{
a named vector of sequence lengths
}
\description{
Get gene models from a remote or local FASTA file
}
\examples{
CElegansFasteCropped = system.file("extdata", 
                                   "C_elegans_cropped_example.fa.gz", 
                                   package="GenomicDistributions")
CElegansChromSizes = getChromSizesFromFasta(CElegansFasteCropped)
}
