% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbor-distances.R
\name{calcNeighborDist}
\alias{calcNeighborDist}
\title{Group regions from the same chromosome together and
calculate the distances of a region to its upstream and
downstream neighboring regions.  
Distances are then lumped into a numeric vector.}
\usage{
calcNeighborDist(query, correctRef = "None")
}
\arguments{
\item{query}{A GRanges or GRangesList object.}

\item{correctRef}{A string indicating the reference genome
to use if distances are corrected for the number of 
regions in a regionSet.}
}
\value{
A numeric vector or list with different vectors containing the
 distances of regions to their upstream/downstream neighbors.
}
\description{
Group regions from the same chromosome together and
calculate the distances of a region to its upstream and
downstream neighboring regions.  
Distances are then lumped into a numeric vector.
}
\examples{
dist = calcNeighborDist(vistaEnhancers)
}
