% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chrom-plots.R
\name{calcChromBinsRefSlow}
\alias{calcChromBinsRefSlow}
\title{Returns the distribution of query over a reference assembly
Given a query set of elements (a GRanges object) and a reference assembly
(*e.g. 'hg38'), this will aggregate and count the distribution of the query
elements across bins of the reference genome. This is a helper function to
create features for common genomes. It is a wrapper of
\code{calcChromBins}, which is more general.}
\usage{
calcChromBinsRefSlow(query, refAssembly, binCount = 3000)
}
\arguments{
\item{query}{A GenomicRanges or GenomicRangesList object with query regions}

\item{refAssembly}{A character vector that will be used to grab chromosome
sizes with \code{getChromSizes}}

\item{binCount}{Number of bins to divide the chromosomes into}
}
\value{
A data.table showing the distribution of regions across bins of the
reference genome.
}
\description{
Returns the distribution of query over a reference assembly
Given a query set of elements (a GRanges object) and a reference assembly
(*e.g. 'hg38'), this will aggregate and count the distribution of the query
elements across bins of the reference genome. This is a helper function to
create features for common genomes. It is a wrapper of
\code{calcChromBins}, which is more general.
}
\examples{
ChromBins = calcChromBinsRef(vistaEnhancers, "hg19")
}
