% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAutomorphisms.R
\name{getAutomorphisms}
\alias{getAutomorphisms}
\alias{getAutomorphisms,AutomorphismList-method}
\alias{getAutomorphisms,list-method}
\alias{getAutomorphisms,DataFrame_OR_data.frame-method}
\title{Get Automorphisms}
\usage{
getAutomorphisms(x, ...)

\S4method{getAutomorphisms}{AutomorphismList}(x)

\S4method{getAutomorphisms}{list}(x)

\S4method{getAutomorphisms}{DataFrame_OR_data.frame}(x)
}
\arguments{
\item{x}{An \code{\link{AutomorphismList-class}}.}

\item{...}{Not in use.}
}
\value{
This function returns an \code{\link{AutomorphismList-class}}
object as a list of \code{\link{Automorphism-class}} objects, which inherits
from \code{\link[GenomicRanges]{GRanges-class}} objects.

An \code{\link{AutomorphismList-class}}

An \code{\link{Automorphism-class}}
}
\description{
For the sake of saving memory, each
\code{\link{Automorphism-class}}
objects is stored in an \code{\link{AutomorphismList-class}}, which  does
not inherits from a \code{\link[GenomicRanges]{GRanges-class}}.
}
\details{
This function just transform each \code{\link{Automorphism-class}}
object into an object from the same class but now inheriting from a
\code{\link[GenomicRanges]{GRanges-class}}.
}
\examples{
## Load a dataset
data("autm", package = "GenomAutomorphism")
aut <- mcols(autm)
aut ## This a DataFrame object

## The natural ranges for the sequence (from 1 to length(aut)) are added
getAutomorphisms(aut)

## A list of automorphisms
aut <- list(aut, aut)
getAutomorphisms(aut)

## Automorphism-class inherits from 'GRanges-class'
aut <- as(autm, "GRanges")
as(aut, "Automorphism")
}
