% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_dist_matrix.R
\name{codon_dist_matrix}
\alias{codon_dist_matrix}
\title{Compute Codon Distance Matrix}
\usage{
codon_dist_matrix(
  genetic_code = "1",
  group = c("Z4", "Z5"),
  weight = NULL,
  cube = c("ACGT", "AGCT", "TCGA", "TGCA", "CATG", "GTAC", "CTAG", "GATC", "ACTG",
    "ATCG", "GTCA", "GCTA", "CAGT", "TAGC", "TGAC", "CGAT", "AGTC", "ATGC", "CGTA",
    "CTGA", "GACT", "GCAT", "TACG", "TCAG"),
  output = c("list", "vector", "dist"),
  num.cores = 1L
)
}
\arguments{
\item{genetic_code}{A single string that uniquely identifies the genetic
code to extract. Should be one of the values in the id or name2 columns of
\code{\link[Biostrings]{GENETIC_CODE_TABLE}}.}

\item{group}{A character string denoting the group representation for the
given codon sequence as shown in reference (2-3).}

\item{weight}{A numerical vector of  weights to compute weighted Manhattan
distance between codons. If \eqn{weight = NULL}, then
\eqn{weight = (1/4,1,1/16)} for \eqn{group =} "Z4" and
\eqn{weight = (1/5,1,1/25)} for \eqn{group =} "Z5" (see
\code{\link{codon_dist}}).}

\item{cube}{A character string denoting one of the 24 Genetic-code cubes,
as given in references (2-3).}

\item{output}{Format of the returned lower triangular matrix: as a list of
63 elements (labeled) or as a labeled vector using codons as labels.}

\item{num.cores}{An integer to setup the number of parallel workers via
\code{\link[parallel]{makeCluster}}.}
}
\value{
A lower triangular matrix excluding the diagonal.
}
\description{
This function computes the codon distance matrix based on the
weighted Manhattan distance between codons estimated with function
\code{\link{codon_dist}}.
}
\details{
By construction, a distance matrix is a symmetric matrix. Hence,
the knowledge of lower triangular matrix is enough for its application to
any downstream analysis.
}
\examples{
## The distance matrix for codons for the Invertebrate Mitochondrial,
## cube "TGCA" with base-triplet represented on the group "Z5". Each 
## coordinate from each returned numerical vector corresponds to the 
## distance between codons given in the coordinate name. 
x <- codon_dist_matrix(genetic_code = "5", cube = "TGCA", group = "Z5",
                    output = "vector")
x[seq(61, 63)]

}
\seealso{
\code{\link{codon_dist}}.
}
