% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_autm.R
\docType{data}
\name{autm}
\alias{autm}
\title{Automorphisms between DNA Sequences from two COVID-19 genomes}
\format{
\link{AutomorphismList} class object.
}
\usage{
data("autm", package = "GenomAutomorphism")
}
\description{
This is a \link{AutomorphismList} object carrying a list of pairwise
automorphisms between the SARS coronavirus GZ02 (GenBank: AY390556.1:
265-13398_13398-21485) and Bat SARS-like coronavirus isolate bat-SL-CoVZC45
(GenBank: MG772933.1:265-1345513455-21542), nonstructural_polyprotein. The
pairwise DNA sequence alignment is available in the dataset named
\link{covid_aln} and the automorphisms were estimated with function
\link{autZ64}.
}
\details{
The alignment of these DNA sequences is available at:
\url{https://github.com/genomaths/seqalignments/raw/master/COVID-19} in
the fasta file
'AY390556.1_265-13398_13398-21485_RNA-POL_SARS_COVI_GZ02.fas'
}
\examples{
data("autm", package = "GenomAutomorphism")
autm

}
\keyword{datasets}
