% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\docType{class}
\name{CodonSeq-class}
\alias{CodonSeq-class}
\alias{CodonSeq}
\alias{coordList}
\alias{coordList,CodonSeq-method}
\alias{seqRanges}
\alias{seqRanges,CodonSeq-method}
\title{A class definition to store codon coordinates given in the Abelian
group and the codon sequence.}
\usage{
coordList(x)

\S4method{coordList}{CodonSeq}(x)

seqRanges(x)

\S4method{seqRanges}{CodonSeq}(x)
}
\arguments{
\item{x}{An object from \code{\link{CodonSeq-class}}.}
}
\value{
Given the slot values define a CodonSeq-class.
}
\description{
An objects from 'CodonSeq' or 'MatrixList' class is returned
by function \code{\link{get_coord}}. This object will store the coordinate
of each sequence in a list of 3D-vectors or a list of vectors located in
the slot named 'CoordList'. The original codon sequence (if provided) will
be stored in the slot named 'SeqRanges'.
}
\examples{
## Load a DNA sequence alignment 
data("aln", package = "GenomAutomorphism")

## Get base coordinates on 'Z5'
coord <- get_coord(
    x = aln,
    cube = "ACGT",
    group = "Z5"
)
coordList(coord)
## Load a DNA sequence alignment
data("aln", package = "GenomAutomorphism")

## Get base coordinates on 'Z5'
coord <- get_coord(
    x = aln,
    cube = "ACGT",
    group = "Z5"
)

seqRanges(coord)
}
\keyword{internal}
