% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneTonic-extras.R
\name{GeneTonicList}
\alias{GeneTonicList}
\alias{GeneTonic_list}
\title{Create a GeneTonicList object}
\usage{
GeneTonicList(dds, res_de, res_enrich, annotation_obj)

GeneTonic_list(dds, res_de, res_enrich, annotation_obj)
}
\arguments{
\item{dds}{A \code{DESeqDataSet} object, normally obtained after running your data
through the \code{DESeq2} framework.}

\item{res_de}{A \code{DESeqResults} object. As for the \code{dds} parameter, this is
also commonly used in the \code{DESeq2} framework.}

\item{res_enrich}{A \code{data.frame} object, storing the result of the functional
enrichment analysis. Required columns for enjoying the full functionality of
\code{\link[=GeneTonic]{GeneTonic()}} include:
\itemize{
\item a gene set identifier (e.g. GeneOntology id, \code{gs_id}) and its term description
(\code{gs_description})
\item a numeric value for the significance of the enrichment (\code{gs_pvalue})
\item a column named \code{gs_genes} containing a comma separated vector of the gene names
associated to the term, one for each term
\item the number of genes in the geneset of interest detected as differentially
expressed (\code{gs_de_count}), or in the background set of genes (\code{gs_bg_count})
See \code{\link[=shake_topGOtableResult]{shake_topGOtableResult()}} or \code{\link[=shake_enrichResult]{shake_enrichResult()}} for examples of such
formatting helpers
}}

\item{annotation_obj}{A \code{data.frame} object, containing two columns, \code{gene_id}
with a set of unambiguous identifiers (e.g. ENSEMBL ids) and \code{gene_name},
containing e.g. HGNC-based gene symbols. This object can be constructed via
the \code{org.eg.XX.db} packages, e.g. with convenience functions such as
\code{\link[mosdef:get_annotation_orgdb]{mosdef::get_annotation_orgdb()}}.}
}
\value{
A \code{GeneTonic}-list object, containing in its named slots the arguments
specified above: \code{dds}, \code{res_de}, \code{res_enrich}, and \code{annotation_obj} - the names
of the list are specified following the requirements for using it as single
input to \code{GeneTonic()}
}
\description{
Create a list for GeneTonic from the single required components.
}
\details{
Having this dedicated function saves the pain of remembering which names
the components of the list should have.
For backwards compatibility, the \code{GeneTonic_list} function is still provided
as a synonim, and will likely be deprecated in the upcoming release cycles.
}
\examples{
library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")
library("AnnotationDbi")

# dds object
data("gse", package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)


# res object
data(res_de_macrophage, package = "GeneTonic")
res_de <- res_macrophage_IFNg_vs_naive

# res_enrich object
data(res_enrich_macrophage, package = "GeneTonic")
res_enrich <- shake_topGOtableResult(topgoDE_macrophage_IFNg_vs_naive)
res_enrich <- get_aggrscores(res_enrich, res_de, anno_df)

gtl_macrophage <- GeneTonicList(
  dds = dds_macrophage,
  res_de = res_de,
  res_enrich = res_enrich,
  annotation_obj = anno_df
)

# now everything is in place to launch the app
if (interactive()) {
  GeneTonic(gtl = gtl_macrophage)
}
}
\author{
Federico Marini
}
